//******************************************
// file			: main.c
// version		: V1.0
// brief		: main program
// note			: 
//******************************************
#ifndef	IO_MEM
#define	IO_MEM
#endif
#include "MQ6811.h"
#include "MQ6801_REG_BIT.h"
//*****************************************************


//-- header guards --//
#ifndef	uchar
#define uchar unsigned char
#endif
#ifndef	uint
#define uint  unsigned int
#endif
#ifndef	ulong
#define ulong unsigned long
#endif

//-- function definition --//
void delay_times(uchar tBase, uint x);
void Key_Wakeup_Init();
void Disable_Key_Wakeup();
void Active_STOP_mode();


uchar flag_WUC;


const uchar t_1ms   = 0;
const uchar t_100us = 1;
const uchar t_6u    = 2;	//HIRC: 8MHz, CGCR/4
const uchar t_3u    = 3;	//HIRC:16MHz, CGCR/4




void main()
{
//-----Disable P10 Reset-----set P10 to GPIO pin
//	SYSCR3.byte = 0x01;
//	SYSCR4.byte = 0xB2;

	P1DR.byte = 0x00;
	P1CR.byte = 0xff;
	P4DR.byte = 0x00;
	P4CR.byte = 0xff;
	P7DR.byte = 0x00;
	P7CR.byte = 0xff;
	P8DR.byte = 0x00;
	P8CR.byte = 0xff;
	P9DR.byte = 0x00;
	P9CR.byte = 0xff;


	WDCDR.byte = 0x4e;				// clear wdt
//----------------------------------------//
//	enter STOP mode ............
//	1. to enter STOP mode, you must pay attention to the input pin can not be floating, or set the unuse pin as the output pin
//	   floating the input pin will cause unknown leakage
	__asm("CPL (_P8DR).0");
	Key_Wakeup_Init();
	Active_STOP_mode();
	Disable_Key_Wakeup();			// release STOP mode and disable KWI
	__asm("CPL (_P8DR).0");





	WDCDR.byte = 0x4e;				// clear wdt
//* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
	while(1)
	{
		WDCDR.byte = 0x4e;			// clear wdt
	}
//* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
}






//*********************************************************************
// name			: Key_Wakeup_Init()
// brief		: Key-on wakeup control
// note			: 
//*********************************************************************
void Key_Wakeup_Init()
{
	P4CR.byte = 0x00;
	P4PU.byte = 0xff;		// if STOP mode release level is high,
							// please set corresponding built-in pull-up resistor or connect to a external pull-up resistor
//..KWI 0.......................
	KWUCR0.bit.b1  = 0;		// stop release level, ( 0:Low / 1:high ) level
	KWUCR0.bit.b0  = 1;		// 1: KWI enable

//..KWI 1.......................
	KWUCR0.bit.b3  = 0;		// stop release level, ( 0:Low / 1:high ) level
	KWUCR0.bit.b2  = 1;		// 1: KWI enable

//..KWI 6.......................
	KWUCR1.bit.b5  = 0;		// stop release level, ( 0:Low / 1:high ) level
	KWUCR1.bit.b4  = 1;		// 1: KWI enable
}


//*********************************************************************
// name			: Disable_Key_Wakeup()
// brief		: disable Key-on wakeup
// note			: 
//*********************************************************************
void Disable_Key_Wakeup()
{
	KWUCR0.byte  = 0x00;	// disable KWI0~3
	KWUCR1.byte  = 0x00;	// disable KWI4~7
}


//*********************************************************************
// name			: Active_STOP_mode()
// brief		: start STOP mode
// note			: 
//				: in STOP mode
//				: please set pins to output low,
//				: floating the input pin will cause unknown leakage
//*********************************************************************
void Active_STOP_mode()
{
	SYSCR1.bit.b5 = 1;	// OUTEN=1, output hold at STOP mode
						// to enter STOP mode, you must pay attention to the input pin can not be floating, or set the unuse pin as the output pin
						// floating the input pin will cause unknown leakage
	SYSCR1.bit.b6 = 1;	// RELM=1,  Level-sensitive release STOP mode
	SYSCR1.bit.b7 = 1;	// enter STOP mode
}









//*********************************************************************
// name			: delay_times(uchar tBase, uint x)
// brief		: time delay function
// note			: ==> t_1ms   = 0;
// 			: ==> t_100us = 1;
// 			: ==> t_6u    = 2;	//HIRC: 8MHz, CGCR/4
// 			: ==> t_3u    = 3;	//HIRC:16MHz, CGCR/4
// 			: ...
//*********************************************************************
void delay_times(uchar tBase, uint x)
{
	uint  i, cgcrT;
	uchar cgcrF[4]={ 2, 4,  8, 1 };		// HIRC =>  8MHz
//	uchar cgcrF[4]={ 4, 8, 16, 2 };		// HIRC => 16MHz

	cgcrT = cgcrF[CGCR.byte];			// 0:fc/4, 1:fc/2, 2:fc/1, 3:fc/8
	switch(tBase){
		case 0:		// t_1ms
			cgcrT *= 110;
			for(; x>0; x--)
				for(i=0; i<cgcrT; i++){}
			break;
		case 1:		// t_100us
			cgcrT *= 11;
			for(; x>0; x--)
				for(i=0; i<cgcrT; i++){}
			break;
		case 2:		// t_6u				// HIRC: 8MHz, CGCR/4
			for(; x>0; x--){}
			break;
		case 3:		// t_3u				// HIRC:16MHz, CGCR/4
			for(; x>0; x--){}
			break;
	}
	WDCDR.byte=0x4e; 			// clear wdt
}








